export MODEL_NAME="CompVis/stable-diffusion-v1-4"
export INSTANCE_DIR="test_images/4"
export CLASS_DIR="regularization/images"
export OUTPUT_DIR="sks_woman"

accelerate launch train_dreambooth.py \
--pretrained_model_name_or_path=$MODEL_NAME  \
--instance_data_dir=$INSTANCE_DIR \
--class_data_dir=$CLASS_DIR \
--output_dir=$OUTPUT_DIR \
--with_prior_preservation --prior_loss_weight=1.0 \
--instance_prompt="a photo of sks woman" \
--class_prompt="a photo of woman" \
--resolution=512 \
--train_batch_size=1 \
--gradient_accumulation_steps=1 \
--gradient_checkpointing \
--use_8bit_adam \
--learning_rate=5e-6 \
--lr_scheduler="constant" \
--lr_warmup_steps=0 \
--num_class_images=151 \
--max_train_steps=800


nohup \
accelerate launch train_dreambooth.py \
--pretrained_model_name_or_path="SD-v1-4"  \
--instance_data_dir="test_images/4" \
--class_data_dir="regularization/samples" \
--output_dir="sks_woman" \
--with_prior_preservation --prior_loss_weight=1.0 \
--instance_prompt="a photo of sks woman" \
--class_prompt="a photo of woman" \
--resolution=512 \
--train_batch_size=1 \
--gradient_accumulation_steps=1 \
--gradient_checkpointing \
--use_8bit_adam \
--learning_rate=1e-6 \
--lr_scheduler="constant" \
--lr_warmup_steps=0 \
--num_class_images=151 \
--max_train_steps=800 \
> train.out 2>&1 &


python inference.py -t 50 -s 10 -m "sks_woman/800" -p "A sks woman is wearing a red dress." -o "generated"

python inference.py -t 50 -s 10 -m "sks_woman/800" -p "Headshot of a sks woman with blonde hair with sky background." -o "generated"
